<?php
if (!defined('ABSPATH')) {
    exit;
}

$total_products = wp_count_posts('product');
$total_published = isset($total_products->publish) ? $total_products->publish : 0;
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header wcdm-header-stock">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-archive"></span>
                <?php esc_html_e('مدیریت موجودی', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php esc_html_e('تغییر وضعیت موجودی محصولات به صورت دسته‌ای', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-stats">
            <div class="wcdm-stat-box">
                <span class="wcdm-stat-number"><?php echo esc_html($total_published); ?></span>
                <span class="wcdm-stat-label"><?php esc_html_e('کل محصولات', 'wc-discount-manager'); ?></span>
            </div>
        </div>
    </div>

    <div class="wcdm-container">
        <div class="wcdm-main-content">
            
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e('محدوده اعمال', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-action-type">
                        <label class="wcdm-radio-card">
                            <input type="radio" name="stock_action_type" value="category" checked>
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-category"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('دسته‌بندی‌های خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب یک یا چند دسته‌بندی', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="stock_action_type" value="brand">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-tag"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('برندهای خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب بر اساس برند', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                        
                        <label class="wcdm-radio-card">
                            <input type="radio" name="stock_action_type" value="all">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-products"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('تمام محصولات', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('تغییر وضعیت تمام محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="stock_action_type" value="product">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-cart"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('محصولات خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب تکی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-stock-category-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-category"></span> <?php esc_html_e('انتخاب دسته‌بندی', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-stock-categories" multiple="multiple" class="wcdm-select2" data-mode="all"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('دسته‌بندی‌هایی که می‌خواهید تغییر وضعیت دهید را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-stock-brand-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-tag"></span> <?php esc_html_e('انتخاب برند', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-stock-brands" multiple="multiple" class="wcdm-select2" data-type="brand"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('برندهایی که می‌خواهید تغییر وضعیت دهید را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-stock-product-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-cart"></span> <?php esc_html_e('انتخاب محصولات', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-stock-products" multiple="multiple" class="wcdm-select2-products"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('نام محصول را جستجو و انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-edit"></span> <?php esc_html_e('یادداشت', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <textarea id="wcdm-stock-notes" rows="2" placeholder="<?php esc_attr_e('توضیحات این تغییرات (اختیاری)...', 'wc-discount-manager'); ?>"></textarea>
                </div>
            </div>

            <div class="wcdm-actions">
                <button type="button" id="wcdm-stock-preview-btn" class="button button-secondary button-large">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('پیش‌نمایش', 'wc-discount-manager'); ?>
                </button>
                <div class="wcdm-action-group">
                    <button type="button" id="wcdm-stock-apply-btn" class="button button-primary button-large" disabled>
                        <span class="dashicons dashicons-no"></span>
                        <?php esc_html_e('ناموجود کردن', 'wc-discount-manager'); ?>
                    </button>
                    <!-- Future: <button>In Stock</button> -->
                </div>
            </div>

            <div class="wcdm-card wcdm-preview-card" id="wcdm-stock-preview-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-list-view"></span> <?php esc_html_e('پیش‌نمایش محصولات', 'wc-discount-manager'); ?></h2>
                    <span class="wcdm-badge" id="wcdm-stock-preview-count">0</span>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-table-wrapper">
                        <table class="wcdm-table" id="wcdm-stock-preview-table">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e('محصول', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('وضعیت فعلی', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('دسته‌بندی', 'wc-discount-manager'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="wcdm-sidebar">
            <div class="wcdm-card wcdm-info-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-info"></span> <?php esc_html_e('راهنما', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <ul class="wcdm-info-list">
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('انتخاب بر اساس دسته یا محصول خاص', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('تغییر وضعیت به "ناموجود"', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('قابل برگشت از طریق لاگ', 'wc-discount-manager'); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include WCDM_PLUGIN_DIR . 'templates/modals.php'; ?>
