<?php
if (!defined('ABSPATH')) {
    exit;
}

$total_discounted = new WP_Query(array(
    'post_type' => 'product',
    'posts_per_page' => -1,
    'fields' => 'ids',
    'post_status' => 'publish',
    'meta_query' => array(
        array(
            'key' => '_sale_price',
            'value' => '',
            'compare' => '!='
        )
    )
));
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header wcdm-header-remove">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-tag"></span>
                <?php esc_html_e('حذف تخفیفات', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php esc_html_e('حذف تخفیفات محصولات به صورت دسته‌ای', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-stats">
            <div class="wcdm-stat-box">
                <span class="wcdm-stat-number"><?php echo esc_html($total_discounted->found_posts); ?></span>
                <span class="wcdm-stat-label"><?php esc_html_e('محصول تخفیف‌دار', 'wc-discount-manager'); ?></span>
            </div>
        </div>
    </div>

    <div class="wcdm-container">
        <div class="wcdm-main-content">
            
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e('نوع عملیات', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-action-type">
                        <label class="wcdm-radio-card">
                            <input type="radio" name="remove_action_type" value="category" checked>
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-category"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('حذف از دسته‌بندی‌های خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب یک یا چند دسته‌بندی', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="remove_action_type" value="brand">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-tag"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('حذف از برندهای خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب بر اساس برند', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                        
                        <label class="wcdm-radio-card">
                            <input type="radio" name="remove_action_type" value="all">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-trash"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('حذف تمام تخفیفات', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('حذف تخفیف از تمامی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-remove-category-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-category"></span> <?php esc_html_e('انتخاب دسته‌بندی', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-remove-categories" multiple="multiple" class="wcdm-select2" data-mode="discounted"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('دسته‌بندی‌هایی که می‌خواهید تخفیفات آن‌ها حذف شود را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-remove-brand-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-tag"></span> <?php esc_html_e('انتخاب برند', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-remove-brands" multiple="multiple" class="wcdm-select2" data-type="brand"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('برندهایی که می‌خواهید تخفیفات آن‌ها حذف شود را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-edit"></span> <?php esc_html_e('یادداشت', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <textarea id="wcdm-remove-notes" rows="2" placeholder="<?php esc_attr_e('دلیل حذف تخفیفات (اختیاری)...', 'wc-discount-manager'); ?>"></textarea>
                </div>
            </div>

            <div class="wcdm-actions">
                <button type="button" id="wcdm-remove-preview-btn" class="button button-secondary button-large">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('پیش‌نمایش', 'wc-discount-manager'); ?>
                </button>
                <button type="button" id="wcdm-remove-btn" class="button button-primary button-large" disabled>
                    <span class="dashicons dashicons-trash"></span>
                    <?php esc_html_e('حذف تخفیفات', 'wc-discount-manager'); ?>
                </button>
            </div>

            <div class="wcdm-card wcdm-preview-card" id="wcdm-remove-preview-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-list-view"></span> <?php esc_html_e('پیش‌نمایش محصولات', 'wc-discount-manager'); ?></h2>
                    <span class="wcdm-badge" id="wcdm-remove-preview-count">0</span>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-table-wrapper">
                        <table class="wcdm-table" id="wcdm-remove-preview-table">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e('محصول', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت اصلی', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت تخفیف', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('درصد تخفیف', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('دسته‌بندی', 'wc-discount-manager'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="wcdm-sidebar">
            <div class="wcdm-card wcdm-info-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-info"></span> <?php esc_html_e('راهنما', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <ul class="wcdm-info-list">
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('قبل از حذف، پیش‌نمایش را بررسی کنید', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('عملیات قابل برگشت است', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('تمام فعالیت‌ها در لاگ ثبت می‌شود', 'wc-discount-manager'); ?></li>
                    </ul>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-clock"></span> <?php esc_html_e('آخرین فعالیت‌ها', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div id="wcdm-recent-logs"><p class="wcdm-loading"><?php esc_html_e('در حال بارگذاری...', 'wc-discount-manager'); ?></p></div>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=wc-discount-manager-logs')); ?>" class="wcdm-view-all">
                        <?php esc_html_e('مشاهده همه', 'wc-discount-manager'); ?>
                        <span class="dashicons dashicons-arrow-left-alt"></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include WCDM_PLUGIN_DIR . 'templates/modals.php'; ?>
