<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header wcdm-header-logs">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-clipboard"></span>
                <?php esc_html_e('گزارش فعالیت‌ها', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php esc_html_e('تاریخچه تمامی عملیات انجام شده', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-actions">
            <button type="button" id="wcdm-export-logs" class="button">
                <span class="dashicons dashicons-download"></span>
                <?php esc_html_e('خروجی CSV', 'wc-discount-manager'); ?>
            </button>
            <button type="button" id="wcdm-clear-logs" class="button wcdm-btn-danger">
                <span class="dashicons dashicons-trash"></span>
                <?php esc_html_e('پاک کردن لاگ‌ها', 'wc-discount-manager'); ?>
            </button>
        </div>
    </div>

    <div class="wcdm-logs-container">
        
        <div class="wcdm-stats-row">
            <div class="wcdm-stat-card">
                <div class="wcdm-stat-icon wcdm-stat-icon-blue">
                    <span class="dashicons dashicons-clipboard"></span>
                </div>
                <div class="wcdm-stat-info">
                    <span class="wcdm-stat-number" id="wcdm-stat-total">0</span>
                    <span class="wcdm-stat-label"><?php esc_html_e('کل عملیات', 'wc-discount-manager'); ?></span>
                </div>
            </div>
            <div class="wcdm-stat-card">
                <div class="wcdm-stat-icon wcdm-stat-icon-green">
                    <span class="dashicons dashicons-cart"></span>
                </div>
                <div class="wcdm-stat-info">
                    <span class="wcdm-stat-number" id="wcdm-stat-products">0</span>
                    <span class="wcdm-stat-label"><?php esc_html_e('محصول پردازش شده', 'wc-discount-manager'); ?></span>
                </div>
            </div>
            <div class="wcdm-stat-card">
                <div class="wcdm-stat-icon wcdm-stat-icon-orange">
                    <span class="dashicons dashicons-undo"></span>
                </div>
                <div class="wcdm-stat-info">
                    <span class="wcdm-stat-number" id="wcdm-stat-undos">0</span>
                    <span class="wcdm-stat-label"><?php esc_html_e('قابل برگشت', 'wc-discount-manager'); ?></span>
                </div>
            </div>
        </div>

        <div class="wcdm-card">
            <div class="wcdm-card-body">
                <div class="wcdm-table-wrapper">
                    <table class="wcdm-table wcdm-logs-table" id="wcdm-logs-table">
                        <thead>
                            <tr>
                                <th><?php esc_html_e('#', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('نوع عملیات', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('مقدار', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('تعداد', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('دسته‌بندی‌ها', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('کاربر', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('تاریخ', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('پایان تخفیف', 'wc-discount-manager'); ?></th>
                                <th><?php esc_html_e('عملیات', 'wc-discount-manager'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="wcdm-logs-body">
                            <tr>
                                <td colspan="9" class="wcdm-loading-row">
                                    <span class="spinner is-active"></span>
                                    <?php esc_html_e('در حال بارگذاری...', 'wc-discount-manager'); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="wcdm-pagination" id="wcdm-pagination"></div>
            </div>
        </div>
    </div>
</div>

<?php include WCDM_PLUGIN_DIR . 'templates/modals.php'; ?>
