<?php
if (!defined('ABSPATH')) {
    exit;
}

$total_products = wp_count_posts('product');
$total_published = isset($total_products->publish) ? $total_products->publish : 0;
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header wcdm-header-add">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-chart-line"></span>
                <?php esc_html_e('افزایش قیمت', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php esc_html_e('افزایش قیمت محصولات به صورت دسته‌ای', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-stats">
            <div class="wcdm-stat-box">
                <span class="wcdm-stat-number"><?php echo esc_html($total_published); ?></span>
                <span class="wcdm-stat-label"><?php esc_html_e('کل محصولات', 'wc-discount-manager'); ?></span>
            </div>
        </div>
    </div>

    <div class="wcdm-container">
        <div class="wcdm-main-content">
            
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e('محدوده اعمال', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-action-type">
                        <label class="wcdm-radio-card">
                            <input type="radio" name="increase_action_type" value="category" checked>
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-category"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('دسته‌بندی‌های خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب یک یا چند دسته‌بندی', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="increase_action_type" value="brand">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-tag"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('برندهای خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب بر اساس برند', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                        
                        <label class="wcdm-radio-card">
                            <input type="radio" name="increase_action_type" value="all">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-products"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('تمام محصولات', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('افزایش قیمت تمامی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="increase_action_type" value="product">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-cart"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('محصولات خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب تکی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-increase-category-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-category"></span> <?php esc_html_e('انتخاب دسته‌بندی', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-increase-categories" multiple="multiple" class="wcdm-select2" data-mode="all"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('دسته‌بندی‌هایی که می‌خواهید قیمت افزایش یابد را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-increase-brand-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-tag"></span> <?php esc_html_e('انتخاب برند', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-increase-brands" multiple="multiple" class="wcdm-select2" data-type="brand"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('برندهایی که می‌خواهید قیمت افزایش یابد را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-increase-product-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-cart"></span> <?php esc_html_e('انتخاب محصولات', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-increase-products" multiple="multiple" class="wcdm-select2-products"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('نام محصول را جستجو و انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-money-alt"></span> <?php esc_html_e('تنظیمات افزایش قیمت', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-form-row">
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label><?php esc_html_e('نوع افزایش', 'wc-discount-manager'); ?></label>
                            <div class="wcdm-discount-type-selector">
                                <label class="wcdm-discount-type-option active">
                                    <input type="radio" name="increase_type" value="percentage" checked>
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-chart-pie"></span>
                                        <?php esc_html_e('درصدی', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                                <label class="wcdm-discount-type-option">
                                    <input type="radio" name="increase_type" value="fixed">
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-money"></span>
                                        <?php esc_html_e('مبلغ ثابت', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label for="wcdm-increase-value"><?php esc_html_e('مقدار افزایش', 'wc-discount-manager'); ?></label>
                            <div class="wcdm-input-group">
                                <input type="number" id="wcdm-increase-value" min="0" step="1" placeholder="0">
                                <span class="wcdm-input-suffix" id="wcdm-increase-suffix">%</span>
                            </div>
                        </div>
                    </div>

                    <div class="wcdm-form-row" style="margin-top: 20px;">
                        <div class="wcdm-form-group">
                            <label class="wcdm-checkbox-label">
                                <input type="checkbox" id="wcdm-increase-rounding-enable">
                                <span><?php esc_html_e('گرد کردن قیمت پس از افزایش', 'wc-discount-manager'); ?></span>
                            </label>
                        </div>
                    </div>

                    <div class="wcdm-form-row" id="wcdm-increase-rounding-options" style="display: none; margin-top: 15px;">
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label><?php esc_html_e('نوع گرد کردن', 'wc-discount-manager'); ?></label>
                            <div class="wcdm-discount-type-selector">
                                <label class="wcdm-discount-type-option active">
                                    <input type="radio" name="increase_rounding_type" value="up" checked>
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-arrow-up-alt"></span>
                                        <?php esc_html_e('گرد کردن به بالا', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                                <label class="wcdm-discount-type-option">
                                    <input type="radio" name="increase_rounding_type" value="down">
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-arrow-down-alt"></span>
                                        <?php esc_html_e('گرد کردن به پایین', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                            </div>
                        </div>

                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label><?php esc_html_e('دقت گرد کردن', 'wc-discount-manager'); ?></label>
                            <select id="wcdm-increase-rounding-precision" class="wcdm-select-field">
                                <option value="1" selected><?php esc_html_e('گرد کردن به نزدیک‌ترین عدد صحیح (1)', 'wc-discount-manager'); ?></option>
                                <option value="10"><?php esc_html_e('گرد کردن به ده‌ها (10)', 'wc-discount-manager'); ?></option>
                                <option value="100"><?php esc_html_e('گرد کردن به صدها (100)', 'wc-discount-manager'); ?></option>
                                <option value="1000"><?php esc_html_e('گرد کردن به هزارها (1,000)', 'wc-discount-manager'); ?></option>
                                <option value="10000"><?php esc_html_e('گرد کردن به ده‌هزارها (10,000)', 'wc-discount-manager'); ?></option>
                                <option value="100000"><?php esc_html_e('گرد کردن به صدهزارها (100,000)', 'wc-discount-manager'); ?></option>
                                <option value="1000000"><?php esc_html_e('گرد کردن به میلیون‌ها (1,000,000)', 'wc-discount-manager'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-edit"></span> <?php esc_html_e('یادداشت', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <textarea id="wcdm-increase-notes" rows="2" placeholder="<?php esc_attr_e('توضیحات این افزایش قیمت (اختیاری)...', 'wc-discount-manager'); ?>"></textarea>
                </div>
            </div>

            <div class="wcdm-actions">
                <button type="button" id="wcdm-increase-preview-btn" class="button button-secondary button-large">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('پیش‌نمایش', 'wc-discount-manager'); ?>
                </button>
                <button type="button" id="wcdm-increase-apply-btn" class="button button-primary button-large" disabled>
                    <span class="dashicons dashicons-yes-alt"></span>
                    <?php esc_html_e('اعمال افزایش قیمت', 'wc-discount-manager'); ?>
                </button>
            </div>

            <div class="wcdm-card wcdm-preview-card" id="wcdm-increase-preview-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-list-view"></span> <?php esc_html_e('پیش‌نمایش قیمت‌های جدید', 'wc-discount-manager'); ?></h2>
                    <span class="wcdm-badge" id="wcdm-increase-preview-count">0</span>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-table-wrapper">
                        <table class="wcdm-table" id="wcdm-increase-preview-table">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e('محصول', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت فعلی', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت جدید', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('دسته‌بندی', 'wc-discount-manager'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="wcdm-sidebar">
            <div class="wcdm-card wcdm-info-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-info"></span> <?php esc_html_e('راهنما', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <ul class="wcdm-info-list">
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('افزایش درصدی یا مبلغ ثابت', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('انتخاب بر اساس دسته، برند یا محصول خاص', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('قابل برگشت از طریق لاگ', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('قیمت اصلی (Regular Price) افزایش می‌یابد', 'wc-discount-manager'); ?></li>
                    </ul>
                </div>
            </div>

            <div class="wcdm-card wcdm-tip-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-lightbulb"></span> <?php esc_html_e('نکته', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <p><?php esc_html_e('افزایش قیمت بر روی قیمت اصلی (Regular Price) محصولات اعمال می‌شود و قیمت فروش (Sale Price) تغییر نمی‌کند.', 'wc-discount-manager'); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include WCDM_PLUGIN_DIR . 'templates/modals.php'; ?>
