<?php
/**
 * قالب صفحه اصلی مدیریت تخفیفات
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-tag"></span>
                <?php _e('مدیریت تخفیفات ووکامرس', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php _e('حذف و مدیریت تخفیفات محصولات به صورت دسته‌ای', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-stats">
            <?php
            $total_discounted = new WP_Query(array(
                'post_type' => 'product',
                'posts_per_page' => -1,
                'fields' => 'ids',
                'meta_query' => array(
                    array(
                        'key' => '_sale_price',
                        'value' => '',
                        'compare' => '!='
                    )
                )
            ));
            ?>
            <div class="wcdm-stat-box">
                <span class="wcdm-stat-number"><?php echo $total_discounted->found_posts; ?></span>
                <span class="wcdm-stat-label"><?php _e('محصول تخفیف‌دار', 'wc-discount-manager'); ?></span>
            </div>
        </div>
    </div>

    <div class="wcdm-container">
        <div class="wcdm-main-content">
            <!-- کارت انتخاب نوع عملیات -->
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-admin-settings"></span>
                        <?php _e('نوع عملیات', 'wc-discount-manager'); ?>
                    </h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-action-type">
                        <label class="wcdm-radio-card">
                            <input type="radio" name="action_type" value="category" checked>
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-category"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php _e('حذف از دسته‌بندی‌های خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php _e('انتخاب یک یا چند دسته‌بندی برای حذف تخفیفات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                        
                        <label class="wcdm-radio-card">
                            <input type="radio" name="action_type" value="all">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-trash"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php _e('حذف تمام تخفیفات', 'wc-discount-manager'); ?></strong>
                                    <p><?php _e('حذف تخفیف از تمامی محصولات فروشگاه', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- کارت انتخاب دسته‌بندی -->
            <div class="wcdm-card" id="wcdm-category-card">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-category"></span>
                        <?php _e('انتخاب دسته‌بندی', 'wc-discount-manager'); ?>
                    </h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-form-group">
                        <label for="wcdm-categories"><?php _e('دسته‌بندی‌های مورد نظر را انتخاب کنید:', 'wc-discount-manager'); ?></label>
                        <select id="wcdm-categories" multiple="multiple" class="wcdm-select2">
                            <!-- دسته‌بندی‌ها با AJAX بارگذاری می‌شوند -->
                        </select>
                        <p class="wcdm-help-text"><?php _e('می‌توانید چند دسته‌بندی را همزمان انتخاب کنید.', 'wc-discount-manager'); ?></p>
                    </div>
                </div>
            </div>

            <!-- کارت یادداشت -->
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-edit"></span>
                        <?php _e('یادداشت (اختیاری)', 'wc-discount-manager'); ?>
                    </h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-form-group">
                        <textarea id="wcdm-notes" rows="3" placeholder="<?php _e('دلیل حذف تخفیفات را یادداشت کنید...', 'wc-discount-manager'); ?>"></textarea>
                    </div>
                </div>
            </div>

            <!-- دکمه‌های عملیات -->
            <div class="wcdm-actions">
                <button type="button" id="wcdm-preview-btn" class="button button-secondary button-large">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php _e('پیش‌نمایش', 'wc-discount-manager'); ?>
                </button>
                <button type="button" id="wcdm-remove-btn" class="button button-primary button-large" disabled>
                    <span class="dashicons dashicons-trash"></span>
                    <?php _e('حذف تخفیفات', 'wc-discount-manager'); ?>
                </button>
            </div>

            <!-- نتیجه پیش‌نمایش -->
            <div class="wcdm-card wcdm-preview-card" id="wcdm-preview-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-list-view"></span>
                        <?php _e('پیش‌نمایش محصولات', 'wc-discount-manager'); ?>
                    </h2>
                    <span class="wcdm-badge" id="wcdm-preview-count">0</span>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-table-wrapper">
                        <table class="wcdm-table" id="wcdm-preview-table">
                            <thead>
                                <tr>
                                    <th><?php _e('محصول', 'wc-discount-manager'); ?></th>
                                    <th><?php _e('قیمت اصلی', 'wc-discount-manager'); ?></th>
                                    <th><?php _e('قیمت تخفیف', 'wc-discount-manager'); ?></th>
                                    <th><?php _e('درصد تخفیف', 'wc-discount-manager'); ?></th>
                                    <th><?php _e('دسته‌بندی', 'wc-discount-manager'); ?></th>
                                    <th><?php _e('عملیات', 'wc-discount-manager'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- داده‌ها با AJAX بارگذاری می‌شوند -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- ساید بار -->
        <div class="wcdm-sidebar">
            <div class="wcdm-card wcdm-info-card">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-info"></span>
                        <?php _e('راهنما', 'wc-discount-manager'); ?>
                    </h2>
                </div>
                <div class="wcdm-card-body">
                    <ul class="wcdm-info-list">
                        <li>
                            <span class="dashicons dashicons-yes-alt"></span>
                            <?php _e('قبل از حذف، پیش‌نمایش را بررسی کنید.', 'wc-discount-manager'); ?>
                        </li>
                        <li>
                            <span class="dashicons dashicons-yes-alt"></span>
                            <?php _e('عملیات قابل برگشت است.', 'wc-discount-manager'); ?>
                        </li>
                        <li>
                            <span class="dashicons dashicons-yes-alt"></span>
                            <?php _e('تمام فعالیت‌ها ثبت می‌شود.', 'wc-discount-manager'); ?>
                        </li>
                        <li>
                            <span class="dashicons dashicons-yes-alt"></span>
                            <?php _e('می‌توانید چند دسته همزمان انتخاب کنید.', 'wc-discount-manager'); ?>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="wcdm-card wcdm-recent-card">
                <div class="wcdm-card-header">
                    <h2>
                        <span class="dashicons dashicons-clock"></span>
                        <?php _e('آخرین فعالیت‌ها', 'wc-discount-manager'); ?>
                    </h2>
                </div>
                <div class="wcdm-card-body">
                    <div id="wcdm-recent-logs">
                        <p class="wcdm-loading"><?php _e('در حال بارگذاری...', 'wc-discount-manager'); ?></p>
                    </div>
                    <a href="<?php echo admin_url('admin.php?page=wc-discount-manager-logs'); ?>" class="wcdm-view-all">
                        <?php _e('مشاهده همه', 'wc-discount-manager'); ?>
                        <span class="dashicons dashicons-arrow-left-alt"></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- مودال پیشرفت -->
<div id="wcdm-progress-modal" class="wcdm-modal" style="display: none;">
    <div class="wcdm-modal-content">
        <div class="wcdm-modal-header">
            <h3><?php _e('در حال پردازش...', 'wc-discount-manager'); ?></h3>
        </div>
        <div class="wcdm-modal-body">
            <div class="wcdm-progress-bar">
                <div class="wcdm-progress-bar-inner"></div>
            </div>
            <p class="wcdm-progress-text"><?php _e('لطفاً صبر کنید...', 'wc-discount-manager'); ?></p>
        </div>
    </div>
</div>

<!-- مودال نتیجه -->
<div id="wcdm-result-modal" class="wcdm-modal" style="display: none;">
    <div class="wcdm-modal-content">
        <div class="wcdm-modal-header">
            <h3 id="wcdm-result-title"></h3>
            <button type="button" class="wcdm-modal-close">&times;</button>
        </div>
        <div class="wcdm-modal-body">
            <div class="wcdm-result-icon">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <p id="wcdm-result-message"></p>
        </div>
        <div class="wcdm-modal-footer">
            <button type="button" class="button button-primary wcdm-modal-close-btn"><?php _e('بستن', 'wc-discount-manager'); ?></button>
        </div>
    </div>
</div>
