<?php
if (!defined('ABSPATH')) {
    exit;
}

$total_products = wp_count_posts('product');
$total_published = isset($total_products->publish) ? $total_products->publish : 0;
?>

<div class="wrap wcdm-wrap">
    <div class="wcdm-header wcdm-header-add">
        <div class="wcdm-header-content">
            <h1>
                <span class="dashicons dashicons-tickets-alt"></span>
                <?php esc_html_e('افزودن تخفیف', 'wc-discount-manager'); ?>
            </h1>
            <p class="wcdm-subtitle"><?php esc_html_e('اعمال تخفیف به محصولات به صورت دسته‌ای', 'wc-discount-manager'); ?></p>
        </div>
        <div class="wcdm-header-stats">
            <div class="wcdm-stat-box">
                <span class="wcdm-stat-number"><?php echo esc_html($total_published); ?></span>
                <span class="wcdm-stat-label"><?php esc_html_e('کل محصولات', 'wc-discount-manager'); ?></span>
            </div>
        </div>
    </div>

    <div class="wcdm-container">
        <div class="wcdm-main-content">
            
            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-admin-settings"></span> <?php esc_html_e('محدوده اعمال', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-action-type">
                        <label class="wcdm-radio-card">
                            <input type="radio" name="add_action_type" value="category" checked>
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-category"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('دسته‌بندی‌های خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب یک یا چند دسته‌بندی', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="add_action_type" value="brand">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-tag"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('برندهای خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب بر اساس برند', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                        
                        <label class="wcdm-radio-card">
                            <input type="radio" name="add_action_type" value="all">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-products"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('تمام محصولات', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('اعمال تخفیف به تمامی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>

                        <label class="wcdm-radio-card">
                            <input type="radio" name="add_action_type" value="product">
                            <div class="wcdm-radio-card-content">
                                <span class="dashicons dashicons-cart"></span>
                                <div class="wcdm-radio-card-text">
                                    <strong><?php esc_html_e('محصولات خاص', 'wc-discount-manager'); ?></strong>
                                    <p><?php esc_html_e('انتخاب تکی محصولات', 'wc-discount-manager'); ?></p>
                                </div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>



            <div class="wcdm-card" id="wcdm-add-category-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-category"></span> <?php esc_html_e('انتخاب دسته‌بندی', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-add-categories" multiple="multiple" class="wcdm-select2" data-mode="all"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('دسته‌بندی‌هایی که می‌خواهید تخفیف اعمال شود را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-add-brand-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-tag"></span> <?php esc_html_e('انتخاب برند', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-add-brands" multiple="multiple" class="wcdm-select2" data-type="brand"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('برندهایی که می‌خواهید تخفیف اعمال شود را انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card" id="wcdm-add-product-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-cart"></span> <?php esc_html_e('انتخاب محصولات', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <select id="wcdm-add-products" multiple="multiple" class="wcdm-select2-products"></select>
                    <p class="wcdm-help-text"><?php esc_html_e('نام محصول را جستجو و انتخاب کنید.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-money-alt"></span> <?php esc_html_e('تنظیمات تخفیف', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-form-row">
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label><?php esc_html_e('نوع تخفیف', 'wc-discount-manager'); ?></label>
                            <div class="wcdm-discount-type-selector">
                                <label class="wcdm-discount-type-option active">
                                    <input type="radio" name="discount_type" value="percentage" checked>
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-chart-pie"></span>
                                        <?php esc_html_e('درصدی', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                                <label class="wcdm-discount-type-option">
                                    <input type="radio" name="discount_type" value="fixed">
                                    <span class="wcdm-discount-type-label">
                                        <span class="dashicons dashicons-money"></span>
                                        <?php esc_html_e('مبلغ ثابت', 'wc-discount-manager'); ?>
                                    </span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label for="wcdm-discount-value"><?php esc_html_e('مقدار تخفیف', 'wc-discount-manager'); ?></label>
                            <div class="wcdm-input-group">
                                <input type="number" id="wcdm-discount-value" min="0" step="1" placeholder="0">
                                <span class="wcdm-input-suffix" id="wcdm-discount-suffix">%</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="wcdm-form-row">
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label for="wcdm-schedule-start">
                                <span class="dashicons dashicons-calendar-alt"></span>
                                <?php esc_html_e('تاریخ شروع تخفیف (اختیاری)', 'wc-discount-manager'); ?>
                            </label>
                            <input type="text" id="wcdm-schedule-start" class="wcdm-datepicker" placeholder="<?php esc_attr_e('انتخاب تاریخ...', 'wc-discount-manager'); ?>">
                        </div>
                        <div class="wcdm-form-group wcdm-form-group-half">
                            <label for="wcdm-schedule-end">
                                <span class="dashicons dashicons-calendar-alt"></span>
                                <?php esc_html_e('تاریخ پایان تخفیف (اختیاری)', 'wc-discount-manager'); ?>
                            </label>
                            <input type="text" id="wcdm-schedule-end" class="wcdm-datepicker" placeholder="<?php esc_attr_e('انتخاب تاریخ...', 'wc-discount-manager'); ?>">
                        </div>
                    </div>
                    <p class="wcdm-help-text"><?php esc_html_e('اگر تاریخ شروع را خالی بگذارید، تخفیف بلافاصله اعمال می‌شود. بعد از تاریخ پایان، قیمت اصلی نمایش داده می‌شود.', 'wc-discount-manager'); ?></p>
                </div>
            </div>

            <div class="wcdm-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-edit"></span> <?php esc_html_e('یادداشت', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <textarea id="wcdm-add-notes" rows="2" placeholder="<?php esc_attr_e('توضیحات این تخفیف (اختیاری)...', 'wc-discount-manager'); ?>"></textarea>
                </div>
            </div>

            <div class="wcdm-actions">
                <button type="button" id="wcdm-add-preview-btn" class="button button-secondary button-large">
                    <span class="dashicons dashicons-visibility"></span>
                    <?php esc_html_e('پیش‌نمایش', 'wc-discount-manager'); ?>
                </button>
                <button type="button" id="wcdm-apply-btn" class="button button-primary button-large" disabled>
                    <span class="dashicons dashicons-yes-alt"></span>
                    <?php esc_html_e('اعمال تخفیف', 'wc-discount-manager'); ?>
                </button>
            </div>

            <div class="wcdm-card wcdm-preview-card" id="wcdm-add-preview-card" style="display: none;">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-list-view"></span> <?php esc_html_e('پیش‌نمایش قیمت‌های جدید', 'wc-discount-manager'); ?></h2>
                    <span class="wcdm-badge" id="wcdm-add-preview-count">0</span>
                </div>
                <div class="wcdm-card-body">
                    <div class="wcdm-table-wrapper">
                        <table class="wcdm-table" id="wcdm-add-preview-table">
                            <thead>
                                <tr>
                                    <th><?php esc_html_e('محصول', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت اصلی', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت فعلی', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('قیمت جدید', 'wc-discount-manager'); ?></th>
                                    <th><?php esc_html_e('دسته‌بندی', 'wc-discount-manager'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="wcdm-sidebar">
            <div class="wcdm-card wcdm-info-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-info"></span> <?php esc_html_e('راهنما', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <ul class="wcdm-info-list">
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('تخفیف درصدی یا مبلغ ثابت', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('انتخاب بر اساس دسته یا محصول خاص', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('امکان تعیین تاریخ شروع و پایان', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('قابل برگشت از طریق لاگ', 'wc-discount-manager'); ?></li>
                        <li><span class="dashicons dashicons-yes-alt"></span> <?php esc_html_e('سازگار با سیستم ووکامرس', 'wc-discount-manager'); ?></li>
                    </ul>
                </div>
            </div>

            <div class="wcdm-card wcdm-tip-card">
                <div class="wcdm-card-header">
                    <h2><span class="dashicons dashicons-lightbulb"></span> <?php esc_html_e('نکته', 'wc-discount-manager'); ?></h2>
                </div>
                <div class="wcdm-card-body">
                    <p><?php esc_html_e('با تعیین تاریخ پایان، تخفیفات به صورت خودکار توسط ووکامرس در زمان مشخص شده غیرفعال می‌شوند و قیمت اصلی نمایش داده می‌شود.', 'wc-discount-manager'); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include WCDM_PLUGIN_DIR . 'templates/modals.php'; ?>
