<?php
/*
Plugin Name: اسلایدر نصویر سفارشی 
Description: A custom slider widget with overlapping square images for Elementor.
Version: 1.3.3
Author: Mostafa Noor - مصطفی نور 
*/

if ( ! defined('ABSPATH') ) {
    exit;
}

// ثبت ویجت در المنتور
function register_custom_slider_widget( $widgets_manager ) {
    class Custom_Slider_Widget extends \Elementor\Widget_Base {

        public function get_name() {
            return 'custom-slider';
        }

        public function get_title() {
            return 'اسلایدر سفارشی';
        }

        public function get_icon() {
            return 'eicon-slider-album';
        }

        public function get_style_depends() {
            return [ 'custom-slider-style' ];
        }

        public function get_script_depends() {
            return [ 'custom-slider-script' ];
        }

        // تنظیمات ویجت
        protected function _register_controls() {

            // بخش محتوا
            $this->start_controls_section(
                'content_section',
                [
                    'label' => 'محتوا',
                    'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'image',
                [
                    'label'   => 'تصویر',
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => \Elementor\Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $this->add_control(
                'images',
                [
                    'label'   => 'تصاویر',
                    'type'    => \Elementor\Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => \Elementor\Utils::get_placeholder_image_src(),
                            ],
                        ],
                    ],
                ]
            );
            $this->end_controls_section();

            // بخش استایل
            $this->start_controls_section(
                'style_section',
                [
                    'label' => 'استایل',
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            $this->add_responsive_control(
                'size',
                [
                    'label'      => 'اندازه کانتینر (عرض و ارتفاع)',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 1000 ],
                        '%'  => [ 'min' => 0, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 400,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-container' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'transition_speed',
                [
                    'label'     => 'سرعت انیمیشن (میلی‌ثانیه)',
                    'type'      => \Elementor\Controls_Manager::NUMBER,
                    'default'   => 500,
                    'min'       => 100,
                    'max'       => 2000,
                    'selectors' => [
                        '{{WRAPPER}} .slide' => 'transition: transform {{VALUE}}ms ease;',
                    ],
                ]
            );

            $this->add_control(
                'border_radius',
                [
                    'label'      => 'حاشیه‌های گرد',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 50 ],
                        '%'  => [ 'min' => 0, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 0,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slide img' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                \Elementor\Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'box_shadow',
                    'label'    => 'سایه',
                    'selector' => '{{WRAPPER}} .slide img',
                ]
            );

            $this->add_control(
                'overlap_amount',
                [
                    'label'   => 'میزان همپوشانی (پیکسل)',
                    'type'    => \Elementor\Controls_Manager::SLIDER,
                    'range'   => [
                        'px' => [ 'min' => 0, 'max' => 100 ],
                    ],
                    'default' => [
                        'size' => 20,
                    ],
                ]
            );

            $this->add_control(
                'overlap_position',
                [
                    'label'   => 'موقعیت همپوشانی',
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'left-bottom'  => 'چپ و پایین',
                        'right-bottom' => 'راست و پایین',
                        'left-top'     => 'چپ و بالا',
                        'right-top'    => 'راست و بالا',
                    ],
                    'default' => 'left-bottom',
                ]
            );

            // کنترل تنظیم شفافیت تصاویر همپوشانی
            $this->add_control(
                'secondary_opacity',
                [
                    'label'      => 'شفافیت تصاویر غیر فعال (٪)',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ '%' ],
                    'range'      => [
                        '%' => [ 'min' => 0, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => '%',
                        'size' => 70,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slide:not(.current)' => 'opacity: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            
            // تنظیم عرض و طول تصویر (به صورت جداگانه و ریسپانسیو)
            $this->add_responsive_control(
                'image_width',
                [
                    'label'      => 'عرض تصویر',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 2000 ],
                        '%'  => [ 'min' => 0, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 100,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slide img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'image_height',
                [
                    'label'      => 'طول تصویر',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 2000 ],
                        '%'  => [ 'min' => 0, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 100,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slide img' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_section();

            // تنظیمات آیکن‌های چپ و راست
            $this->start_controls_section(
                'arrow_settings_section',
                [
                    'label' => 'تنظیمات آیکن‌های جهت‌دار',
                    'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // --- تنظیمات آیکن سمت چپ ---
            $this->add_control(
                'left_arrow_icon',
                [
                    'label'   => 'آیکن سمت چپ',
                    'type'    => \Elementor\Controls_Manager::ICONS,
                    'default' => [
                        'value'   => 'fas fa-chevron-left',
                        'library' => 'fa-solid',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_offset_x',
                [
                    'label'      => 'افست X آیکن چپ',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => -200, 'max' => 200 ],
                        '%'  => [ 'min' => -50, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.left' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_offset_y',
                [
                    'label'      => 'افست Y آیکن چپ',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => -200, 'max' => 200 ],
                        '%'  => [ 'min' => -50, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.left' => 'top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_background_color',
                [
                    'label'     => 'رنگ پس‌زمینه آیکن چپ',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => 'rgba(0,0,0,0.5)',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.left' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_color',
                [
                    'label'     => 'رنگ آیکن چپ',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.left' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_border_radius',
                [
                    'label'      => 'حاشیه گرد آیکن چپ',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 50 ],
                        '%'  => [ 'min' => 0, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 0,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.left' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_padding',
                [
                    'label'      => 'حاشیه داخلی آیکن چپ',
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default'    => [
                        'top'    => 10,
                        'right'  => 10,
                        'bottom' => 10,
                        'left'   => 10,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.left' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // تنظیمات سایز آیکن چپ
            $this->add_responsive_control(
                'left_arrow_icon_size',
                [
                    'label'      => 'سایز آیکن چپ',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [ 'min' => 10, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 24,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.left i'   => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .slider-arrow.left svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            // تنظیمات هاور آیکن چپ
            $this->add_responsive_control(
                'left_arrow_hover_background_color',
                [
                    'label'     => 'رنگ پس‌زمینه در هاور آیکن چپ',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => 'rgba(0,0,0,0.8)',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.left:hover' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'left_arrow_hover_color',
                [
                    'label'     => 'رنگ آیکن در هاور آیکن چپ',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.left:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            // --- تنظیمات آیکن سمت راست ---
            $this->add_control(
                'right_arrow_icon',
                [
                    'label'   => 'آیکن سمت راست',
                    'type'    => \Elementor\Controls_Manager::ICONS,
                    'default' => [
                        'value'   => 'fas fa-chevron-right',
                        'library' => 'fa-solid',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_offset_x',
                [
                    'label'      => 'افست X آیکن راست',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => -200, 'max' => 200 ],
                        '%'  => [ 'min' => -50, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.right' => 'right: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_offset_y',
                [
                    'label'      => 'افست Y آیکن راست',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => -200, 'max' => 200 ],
                        '%'  => [ 'min' => -50, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.right' => 'top: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_background_color',
                [
                    'label'     => 'رنگ پس‌زمینه آیکن راست',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => 'rgba(0,0,0,0.5)',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.right' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_color',
                [
                    'label'     => 'رنگ آیکن راست',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.right' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_border_radius',
                [
                    'label'      => 'حاشیه گرد آیکن راست',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        'px' => [ 'min' => 0, 'max' => 50 ],
                        '%'  => [ 'min' => 0, 'max' => 50 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 0,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.right' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_padding',
                [
                    'label'      => 'حاشیه داخلی آیکن راست',
                    'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default'    => [
                        'top'    => 10,
                        'right'  => 10,
                        'bottom' => 10,
                        'left'   => 10,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.right' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // تنظیمات سایز آیکن راست
            $this->add_responsive_control(
                'right_arrow_icon_size',
                [
                    'label'      => 'سایز آیکن راست',
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range'      => [
                        'px' => [ 'min' => 10, 'max' => 100 ],
                    ],
                    'default'    => [
                        'unit' => 'px',
                        'size' => 24,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} .slider-arrow.right i'   => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .slider-arrow.right svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            // تنظیمات هاور آیکن راست
            $this->add_responsive_control(
                'right_arrow_hover_background_color',
                [
                    'label'     => 'رنگ پس‌زمینه در هاور آیکن راست',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => 'rgba(0,0,0,0.8)',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.right:hover' => 'background: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'right_arrow_hover_color',
                [
                    'label'     => 'رنگ آیکن در هاور آیکن راست',
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'default'   => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .slider-arrow.right:hover' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        // رندر HTML
        protected function render() {
            $settings = $this->get_settings_for_display();
            $images   = $settings['images'];
            if ( empty( $images ) ) {
                return;
            }
            $overlap_amount    = $settings['overlap_amount']['size'];
            $overlap_position  = $settings['overlap_position'];
            $secondary_opacity = $settings['secondary_opacity']['size'];
            ?>
            <div class="slider-container" data-overlap-amount="<?php echo esc_attr( $overlap_amount ); ?>" data-overlap-position="<?php echo esc_attr( $overlap_position ); ?>" data-secondary-opacity="<?php echo esc_attr( $secondary_opacity ); ?>">
                <div class="slider">
                    <?php foreach ( $images as $index => $image ) : ?>
                        <div class="slide" data-index="<?php echo $index; ?>">
                            <img src="<?php echo esc_url( $image['image']['url'] ); ?>" alt="" />
                        </div>
                    <?php endforeach; ?>
                </div>
                <button class="slider-arrow left"><?php \Elementor\Icons_Manager::render_icon( $settings['left_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?></button>
                <button class="slider-arrow right"><?php \Elementor\Icons_Manager::render_icon( $settings['right_arrow_icon'], [ 'aria-hidden' => 'true' ] ); ?></button>
            </div>
            <?php
        }
    }
    $widgets_manager->register( new Custom_Slider_Widget() );
}
add_action( 'elementor/widgets/register', 'register_custom_slider_widget' );

// ثبت استایل و اسکریپت
function custom_slider_widget_assets() {
    wp_enqueue_style( 'custom-slider-style', plugins_url( '/custom-slider-widget.php', __FILE__ ), [], '1.3.2' );
    wp_enqueue_script( 'custom-slider-script', plugins_url( '/custom-slider-widget.php', __FILE__ ), [ 'jquery' ], '1.3.2', true );
}
add_action( 'wp_enqueue_scripts', 'custom_slider_widget_assets' );

// استایل CSS
function custom_slider_widget_css() {
    echo '<style>
        .slider-container {
            position: relative;
            overflow: visible;
            margin: 0 auto;
        }
        .slider {
            position: relative;
            width: 100%;
            height: 100%;
        }
        .slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transition: transform 0.5s ease;
        }
        .slide img {
            object-fit: cover;
            cursor: pointer;
        }
        .slide.current {
            z-index: 10;
            transform: translate(0, 0);
            opacity: 1;
        }
        .slide.next-1 { z-index: 9; }
        .slide.next-2 { z-index: 8; }
        .slide.previous-1 { z-index: 9; }
        .slide.previous-2 { z-index: 8; }
        .slider-arrow {
            position: absolute;
            background: rgba(0,0,0,0.5);
            color: #fff;
            border: none;
            font-size: 24px;
            cursor: pointer;
            z-index: 11;
            transition: all 0.3s ease;
        }
        .slider-arrow:hover {
            background: rgba(0,0,0,0.8);
        }
        /* استایل لایت‌باکس - استفاده از Flexbox جهت مرکز چین شدن محتوا */
        #custom-slider-lightbox {
            display: none;
            position: fixed;
            z-index: 9999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
        }
        #custom-slider-lightbox img {
            max-width: 90%;
            max-height: 90%;
        }
        #custom-slider-lightbox .close-lightbox {
            position: absolute;
            top: 20px;
            right: 30px;
            color: #fff;
            font-size: 40px;
            cursor: pointer;
        }
    </style>';
}
add_action( 'wp_head', 'custom_slider_widget_css' );

// اسکریپت JavaScript
function custom_slider_widget_js() {
    echo '<script>
        jQuery(document).ready(function($) {
            $(".slider-container").each(function() {
                var $container = $(this);
                var $slider = $container.find(".slider");
                var $slides = $slider.find(".slide");
                var slideCount = $slides.length;
                var currentIndex = 0;
                var overlapAmount = parseInt($container.data("overlap-amount")) || 20;
                var overlapPosition = $container.data("overlap-position") || "left-bottom";
                var secondaryOpacity = parseInt($container.data("secondary-opacity")) / 100 || 0.7;

                function updateClasses() {
                    $slides.each(function(index) {
                        var $slide = $(this);
                        $slide.removeClass("current next-1 next-2 previous-1 previous-2");
                        var relativeIndex = (index - currentIndex + slideCount) % slideCount;
                        if (relativeIndex === 0) {
                            $slide.addClass("current");
                            $slide.css({"transform": "translate(0, 0)", "opacity": 1});
                        } else if (relativeIndex === 1) {
                            $slide.addClass("next-1");
                            setOverlapTransform($slide, 1, overlapPosition, overlapAmount);
                            $slide.css("opacity", secondaryOpacity);
                        } else if (relativeIndex === 2 && slideCount > 2) {
                            $slide.addClass("next-2");
                            setOverlapTransform($slide, 2, overlapPosition, overlapAmount);
                            $slide.css("opacity", secondaryOpacity);
                        } else if (relativeIndex === slideCount - 1) {
                            $slide.addClass("previous-1");
                            setOverlapTransform($slide, -1, overlapPosition, overlapAmount);
                            $slide.css("opacity", secondaryOpacity);
                        } else if (relativeIndex === slideCount - 2 && slideCount > 2) {
                            $slide.addClass("previous-2");
                            setOverlapTransform($slide, -2, overlapPosition, overlapAmount);
                            $slide.css("opacity", secondaryOpacity);
                        } else {
                            $slide.css({"transform": "translate(0, 0)", "opacity": secondaryOpacity});
                        }
                    });
                }

                function setOverlapTransform($slide, level, position, amount) {
                    var translateX = 0;
                    var translateY = 0;
                    if (position.indexOf("left") !== -1) {
                        translateX = -amount * level;
                    } else if (position.indexOf("right") !== -1) {
                        translateX = amount * level;
                    }
                    if (position.indexOf("bottom") !== -1) {
                        translateY = amount * level;
                    } else if (position.indexOf("top") !== -1) {
                        translateY = -amount * level;
                    }
                    $slide.css("transform", "translate(" + translateX + "px, " + translateY + "px)");
                }

                updateClasses();

                $container.find(".slider-arrow.left").on("click", function() {
                    currentIndex = (currentIndex - 1 + slideCount) % slideCount;
                    updateClasses();
                });

                $container.find(".slider-arrow.right").on("click", function() {
                    currentIndex = (currentIndex + 1) % slideCount;
                    updateClasses();
                });

                // لایت‌باکس: باز کردن تصویر در مدال
                $container.find(".slide img").on("click", function() {
                    var src = $(this).attr("src");
                    var $lightbox = $("#custom-slider-lightbox");
                    if (!$lightbox.length) {
                        $lightbox = $(\'<div id="custom-slider-lightbox"><span class="close-lightbox">&times;</span><img src="" alt=""/></div>\');
                        $("body").append($lightbox);
                    }
                    $lightbox.find("img").attr("src", src);
                    $lightbox.fadeIn();
                });
            });

            // بستن لایت‌باکس
            $(document).on("click", "#custom-slider-lightbox .close-lightbox, #custom-slider-lightbox", function(e) {
                if(e.target !== this) return;
                $("#custom-slider-lightbox").fadeOut();
            });
        });
    </script>';
}
add_action( 'wp_footer', 'custom_slider_widget_js' );
