<?php
/*
Plugin Name: حذف تخفیف محصولات
Description: حذف تمام تخفیف‌های محصولات ووکامرس با یک کلیک
Version: 1.0
Author: مصطفی نور 
*/

// اطمینان از عدم دسترسی مستقیم به فایل
if (!defined('ABSPATH')) {
    exit;
}

// کلاس اصلی پلاگین
class RemoveDiscountsPlugin {
    
    public function __construct() {
        // اضافه کردن منو به تنظیمات ووکامرس
        add_action('admin_menu', array($this, 'add_plugin_page'));
        
        // ثبت اکشن برای حذف تخفیف‌ها
        add_action('wp_ajax_remove_all_discounts', array($this, 'remove_all_discounts'));
    }

    // اضافه کردن صفحه به منوی ووکامرس
    public function add_plugin_page() {
        add_submenu_page(
            'woocommerce', 
            'حذف تخفیف‌ها', 
            'حذف تخفیف‌ها', 
            'manage_options', 
            'remove-discounts', 
            array($this, 'create_admin_page')
        );
    }

    // ایجاد صفحه تنظیمات
    public function create_admin_page() {
        ?>
        <div class="wrap">
            <h1>حذف تخفیف محصولات</h1>
            <p>با کلیک بر روی دکمه زیر، تمام تخفیف‌های محصولات حذف خواهند شد.</p>
            <button id="remove-discounts-btn" class="button button-primary">حذف همه تخفیف‌ها</button>
            <div id="remove-discounts-result"></div>
        </div>

        <script>
        jQuery(document).ready(function($) {
            $('#remove-discounts-btn').on('click', function() {
                if(confirm('آیا مطمئن هستید؟ این عملیات غیرقابل بازگشت است.')) {
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'remove_all_discounts'
                        },
                        success: function(response) {
                            $('#remove-discounts-result').html(response);
                        }
                    });
                }
            });
        });
        </script>
        <?php
    }

    // متد اصلی برای حذف تخفیف‌ها
    public function remove_all_discounts() {
        global $wpdb;

        // تعداد محصولات با تخفیف
        $discounted_products = $wpdb->get_results(
            "SELECT ID, post_title 
             FROM {$wpdb->posts} p 
             INNER JOIN {$wpdb->postmeta} pm1 ON p.ID = pm1.post_id 
             INNER JOIN {$wpdb->postmeta} pm2 ON p.ID = pm2.post_id 
             WHERE p.post_type = 'product' 
             AND pm1.meta_key = '_sale_price' 
             AND pm1.meta_value != ''"
        );

        $total_updated = 0;

        // حلقه برای به‌روزرسانی محصولات
        foreach ($discounted_products as $product) {
            $regular_price = get_post_meta($product->ID, '_regular_price', true);
            
            // حذف قیمت فروش
            delete_post_meta($product->ID, '_sale_price');
            
            // تنظیم قیمت محصول برابر با قیمت اصلی
            update_post_meta($product->ID, '_price', $regular_price);
            
            $total_updated++;
        }

        // ارسال نتیجه
        wp_send_json_success("تعداد {$total_updated} محصول به‌روزرسانی شدند.");
        wp_die();
    }
}

// راه‌اندازی پلاگین
function initialize_remove_discounts_plugin() {
    if (class_exists('WooCommerce')) {
        new RemoveDiscountsPlugin();
    }
}
add_action('plugins_loaded', 'initialize_remove_discounts_plugin');
